#ifndef MARS_MEnergyEstParam
#define MARS_MEnergyEstParam

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MHillasSrc;
class MEnergyEst;
class MHillas;
class MMcEvt;
class MHMatrix;

class MEnergyEstParam : public MTask
{
private:
    Int_t     fMap[100];

    MHMatrix *fMatrix;

    TList    *fPairs;

    TList    *fHillasSrc;
    TList    *fEnergy;

    MHillas  *fHillas;
    TString   fHillasName;

    TArrayD   fA;
    TArrayD   fB;

    MMcEvt   *fMc;

    void InitCoefficients();

    Double_t GetVal(Int_t i) const;

public:
    MEnergyEstParam(const char *hil="MHillas", const char *name=NULL, const char *title=NULL);
    ~MEnergyEstParam();

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    void Add(const TString hillas, const TString energy);

    void InitMapping(MHMatrix *mat);

    void SetCoeffA(TArrayD arr);
    void SetCoeffB(TArrayD arr);

    ClassDef(MEnergyEstParam, 0) // Task to estimate the energy
};

#endif
