#ifndef MARS_MSigmabar
#define MARS_MSigmabar

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif

class MSigmabar : public MParContainer
{
private:
    Float_t fSigmabar; // Sigmabar (mean standard deviation) of pedestal
    Float_t fSigmabarSector[6]; // --for the 6 sectors of the camera
    Float_t fSigmabarInnerSector[6];
    Float_t fSigmabarOuterSector[6];
    Float_t fSigmabarInner; // --only for inner pixels
    Float_t fSigmabarOuter; // --only for outer pixels  
    UInt_t  fInnerPixels; // Overall number of inner pixels
    UInt_t  fOuterPixels; // Overall number of outer pixels
    Float_t fRatioA; // Ratio of areas (outer/inner pixels)
    Bool_t fCalcPixNum;

public:

    MSigmabar(const char *name=NULL, const char *title=NULL);
    ~MSigmabar();
    
    void Print(Option_t *) const;
 
    Float_t GetSigmabar() const       { return fSigmabar;       }
    Float_t GetSigmabarInner() const  { return fSigmabarInner;  }
    Float_t GetSigmabarOuter() const  { return fSigmabarOuter;  }
    Float_t GetSigmabarSector(const Int_t sector) const 
                              { return fSigmabarSector[sector]; } 
  
    //   void SetSigmabar(Float_t f, Float_t i, Float_t o) 
    //      { fSigmabar = f; fSigmabarInner = i; fSigmabarOuter = o; }
    //    void SetSigmabarInner(Float_t f) { fSigmabarInner = f; }
    //    void SetSigmabarOuter(Float_t f) { fSigmabarOuter = f; }   

    Bool_t Calc(const MGeomCam &geom, const MPedestalCam &ped);
      
    ClassDef(MSigmabar, 1)  // Storage Container for Sigmabar
};

#endif

