#ifndef MARS_MSigmabarCalc
#define MARS_MSigmabarCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

#ifndef MARS_MMcEvt
#include "MMcEvt.hxx"
#endif

#ifndef MARS_MPedestalCam
#include "MPedestalCam.h"
#endif

#ifndef MARS_MSigmabar
#include "MSigmabar.h"
#endif

#ifndef MARS_MSigmabarParam
#include "MSigmabarParam.h"
#endif

class MSigmabarCalc : public MTask
{
private:
    const MGeomCam     *fCam;  
    const MPedestalCam *fPed;  
    MSigmabar    *fSig;
    Double_t fSigmabarMin; // Parametrization
    Double_t fSigmabarMax;
    Double_t fThetaMin;
    Double_t fThetaMax;
    MSigmabarParam *fSigParam;
    MMcEvt *fMcEvt;
    void Reset();

public:
    MSigmabarCalc(const char *name=NULL, const char *title=NULL);
    ~MSigmabarCalc();

    Bool_t PreProcess(MParList *pList);
    Bool_t ReInit(MParList *pList);
    Bool_t Process();

    ClassDef(MSigmabarCalc, 2)    // task for calculating sigmabar
}; 

#endif

