/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MHCerPhotEvt
//
/////////////////////////////////////////////////////////////////////////////
#include "MHCerPhotEvt.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"
#include "MCerPhotEvt.h"

ClassImp(MHCerPhotEvt);

// --------------------------------------------------------------------------
//
// Setup four histograms for Width, Length
//
MHCerPhotEvt::MHCerPhotEvt(const char *name, const char *title)
    : fEvt(NULL)
{
    //
    //   set the name and title of this object
    //
    fName  = name  ? name  : "MHCerPhotEvt";
    fTitle = title ? title : "Sum up camera events";

    fSum.InitSize(577);
    for (int i=0; i<577; i++)
        fSum.AddPixel(i, 0, 0);
}

// --------------------------------------------------------------------------
//
// Setup the Binning for the histograms automatically if the correct
// instances of MBinning (with the names 'BinningWidth' and 'BinningLength')
// are found in the parameter list
// Use this function if you want to set the conversion factor which
// is used to convert the mm-scale in the camera plain into the deg-scale
// used for histogram presentations. The conversion factor is part of
// the camera geometry. Please create a corresponding MGeomCam container.
//
Bool_t MHCerPhotEvt::SetupFill(const MParList *plist)
{
    fEvt = (MCerPhotEvt*)plist->FindObject("MCerPhotEvt");
    if (!fEvt)
        *fLog << warn << GetDescriptor() << ": No MCerPhotEvt available..." << endl;

    return kTRUE;
}

// --------------------------------------------------------------------------
//
// Fill the histograms with data from a MHillas-Container.
// Be careful: Only call this with an object of type MHillas
//
Bool_t MHCerPhotEvt::Fill(const MParContainer *par)
{
    const MCerPhotEvt *evt = par ? (MCerPhotEvt*)par : fEvt;
    if (!evt)
    {
        *fLog << err << dbginf << "No MCerPhotEvt found..." << endl;
        return kFALSE;
    }

    const UInt_t n = evt->GetNumPixels();

    for (UInt_t i=0; i<n; i++)
    {
        const MCerPhotPix &pix = (*evt)[i];

        fSum[pix.GetPixId()].AddNumPhotons(pix.GetNumPhotons());
    }
    return kTRUE;
}

