#ifndef MARS_MContinue
#define MARS_MContinue

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MContinue                                                               //
//                                                                         //
// Does nothing than return kCONTINUE in the Process-fucntion              //
// (use with filters)                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MFilter;

class MContinue : public MTask
{
private:
    Bool_t PreProcess(MParList *list);
    Bool_t Process() { return kCONTINUE; }

    enum { kIsOwner = BIT(14) };

public:
    MContinue(const TString rule="", const char *name=NULL, const char *title=NULL);
    MContinue(MFilter *f, const char *name=NULL, const char *title=NULL);
    ~MContinue();

    void SetFilter(MFilter *filter) { if (!TestBit(kIsOwner)) MTask::SetFilter(filter); }

    ClassDef(MContinue, 1) //Task returning kCONTINUE
};

#endif
