#ifndef MARS_MFillH
#define MARS_MFillH

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MH;
class MData;
class MParList;

class MMap;

class MFillH : public MTask
{
private:
    MParContainer *fParContainer;
    TString fParContainerName;

    MH* fH;
    TString fHName;

    MData *fIndex;    // MData object describing the 'key' to an automatic index for an MHArray
    MMap  *fMapIdx;   //! Map to map key-index-pair for an MHArray (MMap see MFillH.cc)

    TString ExtractName(const char *name) const;
    TString ExtractClass(const char *name) const;

    void Init(const char *name, const char *title);

    void StreamPrimitive(ofstream &out) const;

public:
    MFillH();
    MFillH(const char *hist, const char *par=NULL, const char *name=NULL, const char *title=NULL);
    MFillH(const char *hist, MParContainer *par,   const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         const char *par=NULL, const char *name=NULL, const char *title=NULL);
    MFillH(MH *hist,         MParContainer *par,   const char *name=NULL, const char *title=NULL);

    ~MFillH();

    void SetRuleForIdx(const TString rule);
    void SetRuleForIdx(MData *rule);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MFillH, 1) // Task to fill a histogram with data from a parameter container
};
    
#endif

