#ifndef MARS_MHEffOnTimeTheta
#define MARS_MHEffOnTimeTheta

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH1
#include "TH1.h"
#endif

class MTime;
class TH2D;
class MParList;

class MHEffOnTimeTheta : public MH
{
private:
    TH1D fHEffOn;
    TH1D fHChi2;
    TH1D fHN0del;
    TH1D fHLambda;

public:
    MHEffOnTimeTheta(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TH1D *GetHist() { return &fHEffOn; }
    const TH1D *GetHist() const { return &fHEffOn; }

    void Calc(TH2D *hist);

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHEffOnTimeTheta, 0) //1D-plot of Delta t vs. Theta
};

#endif


