#ifndef MARS_MSelBasic
#define MARS_MSelBasic

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelBasic                                                               //
//                                                                         //
// Task to evaluate basic cuts                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MPedestalCam;
class MCerPhotEvt;
class MHillas;
class MMcEvt;
class MRawRunHeader;

class MSelBasic : public MTask
{
private:
    const MPedestalCam *fPed;      // Pedestal information
    const MGeomCam     *fCam;      // Camera Geometry 
    const MCerPhotEvt  *fEvt;      // Cerenkov Photon Event 
    const MMcEvt       *fMcEvt;       
    const MRawRunHeader *fRawRun;       

          Int_t        fErrors[2];

public:
    MSelBasic(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    Bool_t SwTrigger();

    ClassDef(MSelBasic, 0)   // Task to evaluate basic cuts
};

#endif











