#ifndef MARS_MSelStandard
#define MARS_MSelStandard

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelStandard                                                            //
//                                                                         //
// Task to evaluate standard cuts                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;

class MSelStandard : public MTask
{
private:
    const MGeomCam    *fCam;      // Camera Geometry 
    const MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    const MMcEvt      *fMcEvt;       
    const MHillas     *fHil;       
    const MHillasSrc  *fHilsrc;       

          Double_t     fMm2Deg;   // conversion mm to degrees in camera
          Int_t        fErrors[2];

public:
    MSelStandard(const MHillas *fHil, const MHillasSrc *fHilsrc,
                 const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();


    ClassDef(MSelStandard, 0)   // Task to evaluate standard cuts
};

#endif











