#ifndef MARS_MTrigLvl2
#define MARS_MTrigLvl2

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MMcTrig;
class MGeomCamMagic;
class MCamDisplay;


class MTrigLvl2 : public MParContainer
{

 private:
  Int_t fPixels[36][19];  // Array with the triggered pixels after Lvl1
                          // First index:  pixels index in trigger cell       
                          // Second index: trigger cell number  

  Int_t fLutPseudoSize;  // number of compact pixels in one lut

  MMcTrig *fMcTrig;
  MGeomCamMagic *fGeomcam;  
  MCamDisplay *fCam;

   
 public: 
  MTrigLvl2(const char* name = NULL, const char* title = NULL);
  
  
  void DrawCell(Int_t cell);  
  void DrawLv1();

  void Print(Int_t cell=-1) const;

  void SetLv1(MMcTrig *trig = NULL); 
  void SetPixelFired(Int_t pixel, Int_t fired=1);
 
  Int_t GetCellNumberFired(int cell);
  Int_t GetBiggerFiredCell();

  Int_t GetLutCompactPixel(int cell, int lut, int neighpix=2);
  Int_t GetLutPseudoSize(int neighpix=2);
  
  ClassDef(MTrigLvl2,0) // Container for 2nd Level Trigger selection parameters
};

#endif


