#ifndef MARS_MFEventSelector
#define MARS_MFEventSelector

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFEventSelector                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;

class MFEventSelector : public MFilter
{
private:
    Int_t   fNumTotalEvts;
    Int_t   fNumSelectEvts;
    Float_t fSelRatio;

    Int_t   fNumSelectedEvts; //!

    Bool_t  fResult;
    TString fRead;

    void StreamPrimitive(ofstream &out) const;

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    enum { kNumTotalFromFile = BIT(14) };
    /*
     enum { kUseFixedRatio=BIT(14) }
     */

public:
    // MFEventSelector();
    MFEventSelector(const char *name=NULL, const char *title=NULL,
                    const char *read="MRead");
    ~MFEventSelector();

    Bool_t IsExpressionTrue() const { return fResult; }

    void SetNumTotalEvts(Int_t n) { fNumTotalEvts = n; ResetBit(kNumTotalFromFile); }
    void SetNumSelectEvts(Int_t n) { fNumSelectEvts = n; }
    void SetSelectionRatio(Float_t f) { fSelRatio = f; }

    /*
     void SetUseFixedRatio(Bool_t b=kTRUE) { b ? SetBit(kUseFixedRatio) : ResetBit(kUseFixedRatio); }
     */

    ClassDef(MFEventSelector, 0) // A Filter to select events from files
};

#endif
