#ifndef MARS_MObservatory
#define MARS_MObservatory

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MObservatory : public MParContainer
{
public:
    enum LocationName_t
    {
        kMagic1,
        kWuerzburgCity
    };

private:
    LocationName_t fObservatoryKey;  //!

    TString  fObservatoryName;       //! Name of the observatory

    Double_t fLongitude;             //! [rad] Longitude of observatory (+ east)
    Double_t fLatitude;              //! [rad] Latitude of observatory (+ north)

    Double_t fHeight;                //! [m] height of observatory

    void Init(const char *name, const char *title);

    Double_t Daf2rad(Int_t deg, UInt_t min, Double_t sec)
    {
        /* pi/(180*3600):  arcseconds to radians */
#define DAS2R 4.8481368110953599358991410235794797595635330237270e-6
        return DAS2R * (60.0 * (60.0 * (Double_t)deg + (Double_t)min) + sec);
    }

public:
    MObservatory(const char *name=NULL, const char *title=NULL);
    MObservatory(LocationName_t key, const char *name=NULL, const char *title=NULL);

    void SetLocation(LocationName_t name);

    void Print(Option_t *) const;

    const TString &GetObservatoryName() const { return fObservatoryName; }

    Double_t GetLatitudeDeg() const     { return fLatitude*kRad2Deg; }  //[deg]
    Double_t GetLongitudeDeg() const    { return fLongitude*kRad2Deg; } //[deg]

    Double_t GetLatitudeRad() const     { return fLatitude; }           //[rad]
    Double_t GetLongitudeRad() const    { return fLongitude; }          //[rad]

    Double_t GetPhi() const             { return fLatitude; }           //[rad]
    Double_t GetElong() const           { return fLongitude; }          //[rad]

    Double_t GetHeight() const          { return fHeight; }

    LocationName_t GetObservatoryKey() const { return fObservatoryKey; }

    ClassDef(MObservatory, 0)

};

#endif

