#ifndef MGSTARGUIDER_H
#define MGSTARGUIDER_H

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#ifndef CAMERA_H
#include "Camera.h"
#endif

#include "MGList.h"
#include "MGImage.h"

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

class AltAz;
class RaDec;

class TTimer;

class TGMenuBar;
class TGPopupMenu;
class TGTextEntry;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;

class MGStarguider : public Camera, public TGMainFrame
{
private:
    MGList        *fList;

    TGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    TGPopupMenu   *fDisplay;
    TGPopupMenu   *fWrite;
    TGPopupMenu   *fFileType;
    TGPopupMenu   *fWriteType;
    TGPopupMenu   *fWriteRate;
    TGPopupMenu   *fInterpol;
    TGPopupMenu   *fSetup;
    TGPopupMenu   *fLimMag;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    TGTextEntry   *fPixSize;

    StarCatalog   *fSao;

    RaDec *fRaDec;

    TTimer *fTimer;

    const MObservatory::LocationName_t fObservatory;

    Int_t fDx;
    Int_t fDy;

    int fIntRate;
    int fWrtRate;

    void SetPixSize(const double pixsize);
    void Toggle(TGPopupMenu *p, UInt_t id);
    void GetCoordinates();
    void CalcTrackingError(MStarList &, MStarList &);

    Bool_t HandleTimer(TTimer *t);

public:
    MGStarguider(MObservatory::LocationName_t key);
    virtual ~MGStarguider();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
    Bool_t HandleDoubleClick(Event_t *event);

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    ClassDef(MGStarguider, 0)
};

#endif
