#ifndef MARS_MSelStandard
#define MARS_MSelStandard

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelStandard                                                            //
//                                                                         //
// Task to evaluate standard cuts                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;

class MSelStandard : public MTask
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fErrors[4];
    TString      fHilName;
    TString      fHilSrcName; 

public:
    MSelStandard(const char *HilName, const char *HilSrcName,
                 const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();


    ClassDef(MSelStandard, 0)   // Task to evaluate standard cuts
};

#endif











