#ifndef MARS_MRanForestCalc
#define MARS_MRanForestCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MHadronness;
class MDataArray;
class MRanTree;
class MRanForest;

class MRanForestCalc : public MTask
{
private:
    Int_t  fNum;             // number of trees used to compute hadronness

    MHadronness *fHadroness; //! Output container for calculated hadroness
    MDataArray *fData;       //! Used to store the MDataChains to get the event values
    MRanForest *fRanForest;
    MRanTree   *fRanTree;

public:
    MRanForestCalc(const char *name=NULL, const char *title=NULL);
    ~MRanForestCalc();

    void SetUseNumTrees(UShort_t n=100) { fNum = n; }

    Bool_t PreProcess(MParList *plist);
    Bool_t Process();

    ClassDef(MRanForestCalc, 0) // Task
};

#endif
