#ifndef MARS_MRanTree
#define MARS_MRanTree

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayI
#include <TArrayI.h>
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class TMatrix;
class TVector;
class TRandom;
class MDataArray;

class MRanTree : public MParContainer
{
private:
    Int_t fNdSize;
    Int_t fNumTry;

    Int_t fNumNodes;
    Int_t fNumEndNodes;
    MDataArray *fData;

    TArrayI fBestVar;
    TArrayI fTreeMap1; 
    TArrayI fTreeMap2; 
    TArrayF fBestSplit;

public:
    MRanTree(const char *name=NULL, const char *title=NULL);

    void SetNdSize(Int_t n);
    void SetNumTry(Int_t n);
    void SetRules(MDataArray *rules);

    MDataArray *GetData() { return fData;}

    Int_t GetNdSize() const { return fNdSize; }
    Int_t GetNumTry() const { return fNumTry; }
    Int_t GetNumNodes()          const { return fNumNodes; }
    Int_t GetNumEndNodes()       const { return fNumEndNodes; }

    Int_t GetBestVar(Int_t i)    const { return fBestVar.At(i); }
    Int_t GetTreeMap1(Int_t i)   const { return fTreeMap1.At(i); }
    Int_t GetTreeMap2(Int_t i)   const { return fTreeMap2.At(i); }
    Int_t GetNodeClass(Int_t i)  const { return fBestVar.At(i)+2; }
    Int_t GetNodeStatus(Int_t i) const { return TMath::Sign(1,fBestVar.At(i));}
    Float_t GetBestSplit(Int_t i)const { return fBestSplit.At(i); }

    // functions used in tree growing process
    void GrowTree(TMatrix &mhad,TMatrix &mgam,Int_t numdata, Int_t numdim,TArrayI &hadtrue,
                  TArrayI &datasort,TArrayI &datarang,TArrayF &ginidec,TArrayF &classpopw,
                  TArrayI &jinbag,TArrayF &winbag,TArrayF &weight,TRandom &rand);

    Int_t FindBestSplit(TArrayI &datasort,TArrayI &datarang,TArrayI &hadtrue,Int_t mdim,
                        Int_t numdata,Int_t ndstart,Int_t ndend,TArrayF &tclasspop,
                        Int_t &msplit,Float_t &decsplit,Int_t &nbest,TArrayI &ncase,
                        TArrayI &jinbag,TArrayI &iv,TArrayF &winbag,TArrayF &wr,
                        TArrayF &wc,TArrayF &wl,Int_t kbuild,TRandom &rand);

    void MoveData(TArrayI &datasort,Int_t mdim,Int_t numdata,Int_t ndstart,
                  Int_t ndend,TArrayI &idmove,TArrayI &ncase,Int_t msplit,
                  Int_t nbest,Int_t &ndendl);

    void BuildTree(TArrayI &datasort,TArrayI &datarang,TArrayI &hadtrue,Int_t mdim,
                   Int_t numdata,TArrayI &bestsplit,TArrayI &bestsplitnext,
                   TArrayF &ginidec,TArrayI &nodepop,TArrayI &nodestart,TArrayF &tclasspop,
                   Int_t nrnodes,TArrayI &idmove,TArrayI &ncase,TArrayI &parent,
                   TArrayI &jinbag,TArrayI &iv,TArrayF &winbag,TArrayF &wr,TArrayF &wc,
                   TArrayF &wl,Int_t ninbag,TRandom &rand);

    Double_t TreeHad(TVector &event);
    Double_t TreeHad();

    Bool_t AsciiWrite(ostream &out) const;

    ClassDef(MRanTree, 1) // Storage container for tree structure
};

#endif
