/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Robert Wagner  10/2002 <mailto:magicsoft@rwagner.de>
!   Author(s): Thomas Bretz   2/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2002-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MObservatory                                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MObservatory.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MObservatory);

void MObservatory::Init(const char *name, const char *title)
{
    fName  = name  ? name  : "MObservatory";
    fTitle = title ? title : "Storage container for coordinates of an observatory";   
}

MObservatory::MObservatory(const char *name, const char *title)
{
    Init(name, title);

    SetLocation(kMagic1);
}

MObservatory::MObservatory(LocationName_t key, const char *name=NULL, const char *title=NULL)
{
    Init(name, title);

    SetLocation(key);
}

void MObservatory::SetLocation(LocationName_t name)
{
    switch (name)
    {
    case kMagic1:
        fLatitude  = Dms2Rad( 28, 45, 30.0);
        fLongitude = Dms2Rad(-17, 52, 48.0);
        fHeight    = 2326; // m
        fObservatoryName = "Observatorio del Roque de los Muchachos (Magic1)";
        return;

    case kWuerzburgCity:
        fLatitude  = Dms2Rad(51, 38, 48.0);
        fLongitude = Dms2Rad( 9, 56, 36.0);
        fHeight    = 300;
        fObservatoryName = "Wuerzburg City";
        return;

    }
}

void MObservatory::Print(Option_t *) const
{
    *fLog << all;
    *fLog << fObservatoryName << endl;
    *fLog << "Latitude " << (fLatitude > 0 ? (fLatitude*kRad2Deg) : -(fLatitude*kRad2Deg)) << " deg " << (fLatitude > 0 ? "W" : "E") << endl;
    *fLog << "Longitude " << (fLongitude > 0 ? (fLongitude*kRad2Deg) : -(fLongitude*kRad2Deg)) <<" deg " << (fLongitude < 0 ? "N" : "S") << endl;
    *fLog << "Height " << fHeight << "m" << endl;
}

