#ifndef __RFL_INIT__
#define __RFL_INIT__

/*  Constant definitions  */
#define LINE_MAX_LENGTH 128		/*  parsing buffer sz.	*/
#define NR_OF_CPHOTONS 65535 		/*  CPhotons sz.	*/
#define PH_IN_DATABLOCK	39		/*  Photons in datablk 	*/
#define	SHOW_ME		500		/*  How many evts among two logs  */
#define	FALSE		0
#define	TRUE		1

/*  Macros  */
#define ARRAY_SZ(A)	(sizeof(A)/sizeof(A[0]))

/*  Tags inside reflector file  */
#define SIZE_OF_FLAGS		13

#define FLAG_START_OF_RUN	"\nSTART---RUN\n"
#define FLAG_START_OF_EVENT	"\nSTART-EVENT\n"
#define FLAG_END_OF_EVENT	"\nEND---EVENT\n"
#define FLAG_END_OF_RUN		"\nEND-----RUN\n"
#define FLAG_END_OF_FILE	"\nEND----FILE\n"
#define FLAG_END_OF_STDIN	"\nEND---STDIN\n"

/*  Prototypes  */
void init(char *filename);

/*  External declarations  */
extern FILE *filelist;			/*  filelist ptr	*/
extern FILE *rflfile;			/*  reflector (out)file	*/
extern FILE *cerfile;			/*  current cerfile	*/
extern char  cername[];			/*  current cername	*/
extern long  first_Event;		/*  first proc. event	*/
extern long  last_Event;		/*  last proc. event	*/
extern long  max_Events;		/*  max proc. events	*/
extern float low_Ecut;			/*  lower Ecut (GeV)	*/
extern float high_Ecut;			/*  upper Ecut (GeV)	*/

extern int   is_Fixed_Target;		/*  fixed target?	*/
extern float fixed_Theta;		/*  zenith angle (rad)	*/
extern float fixed_Phi;			/*  azi (0N->90E) (rad)	*/

extern float Telescope_x, Telescope_y;  /* Telescope coordinates (cm) */

extern int   wobble_position;

extern int   is_Random_Pointing;	/*  random pointing?	*/
extern float Random_Pointing_MaxDist;	/*  in metres		*/
extern int   nRepeat_Random;		/*  nr of times a sh. is reused */
extern long  Seeds[2];			/*  random seeds	*/

extern float ct_Focal_mean;		/*  focal dist. (mean) (cm)	*/
extern float ct_PSpread_mean;		/*  pt. spread fn. (mean) (cm)	*/
extern float ct_PSpread_std;		/*  pt. spread fn. (std) (cm)	*/
extern float ct_BlackSpot_rad;		/*  black spot radius (cm)	*/
extern float ct_RMirror;		/*  rad. of single mirror (cm)	*/
extern int   ct_NMirrors;		/*  number of mirrors		*/
extern float ct_CameraWidth;		/*  camera width (cm)		*/
extern int   ct_NPixels;		/*  number of pixels		*/
extern float ct_PixelWidth;		/*  pixel width (cm)		*/


typedef struct
{   int   i;				/*  mirror id			*/
    float f,				/*  focal length (cm)		*/
	  sx, sy,			/*  curvilinear coords. (cm)	*/
	  x, y, z,			/*  rectangular coords. (cm)	*/
	  theta, phi,			/*  angles of mirror axis	*/
	  xn, yn, zn;			/*  versor of mirror axis	*/
}   mirror;

extern mirror *ct_data;		        /*  ptr to mirror data	        */
extern int     nReflectivity;		/*  nr of refl. table elements	*/
extern float  *Reflectivity[];		/*  ptr to refl. table		*/
extern float  *AxisDeviation[];		/*  ptr to axisdev. table	*/

/*  Photon structures  */
typedef struct
{   float w,				/*  photon wavelength (nm)	*/
	  x, y,				/*  (ground) impact point (cm)	*/
	  u, v,				/*  direction cosines		*/
	  t,				/*  arrival time (ns)		*/
	  h;				/*  production height (cm)	*/
}   photon;

typedef struct
{   float w,				/*  cphoton wavelength (nm)	*/
	  x, y,				/*  (chamber) imp. point (cm)	*/
	  u, v,				/*  direction cosines		*/
	  t,				/*  arrival time (ns)		*/
	  h,				/*  production height (cm)	*/
	  phi;				/*  (chamber) inc. angle (rad)	*/
}   cphoton;
extern cphoton *CPhotons;

/*  Strings  */
#define RFL__START_MSG		/*  program, version	*/ \
    "\n  ################################################\n" \
    "    %s %s\n\n    Simulation of the reflector\n" \
    "        - J.C. Gonzalez - May 1998\n" \
    "    Single file version\n" \
    "        - D. Bastieri & C. Bigongiari - Jan 2000\n" \
    "    Version 0.6\n" \
    "        - A. Moralejo - January 2003\n" \
    "  ################################################\n\n"
#define SIGN_ERROR_FTL		/*  program, version	*/ \
    "Signature of parameters file is not correct.\n" \
    " *** Should be: **%s %s**.\n"
#define SKIP_TOKEN_MSG		/*  skipped token	*/ \
    " *** Skipping unknown token [%s].\n"
#define GEOM_NSPEC_FTL		/*  no parms		*/ \
    "No geometry file given.\n" \
    " *** Please specify its name after the \"ct_file\" directive.\n"
#define CPHS_ALLOC_FTL          /*  cphotons	       */ \
    "Cannot allocate enough memory space for %d cphotons.\n"
#define CPHS_ALLOC_LOG          /*  cphotons	       */ \
    "Allocated memory for %d cphotons.\n"
#define CERF_NFND__MSG		/*  cername		*/ \
    " *** Cerfile \"%s\" not found.\n"
#define CERF_OPEN__LOG		/*  cername		*/ \
    "Opened cerfile \"%s\".\n"
#define CERF_ERROR_LOG		/*  cername		*/ \
    "Error while reading cerfile \"%s\": skipping it.\n"
#define EVTN_WRONG_ERR		/*  first, last, cername	*/ \
    " *** Event boundaries [%ld, %ld] wrong for \"%s\".\n" \
    " *** Reading all events.\n"
#define TEMP_ERROR_FTL		/*  no parms		*/ \
    "Cannot open a temporary file: unable to handle overflow."
#define INFO_EVENT_LOG		/*  run, evt, energy	*/ \
    "Run %.0f, event %.0f: energy = %f.\n"
#define MEM__FREE__MSG		/*  no parms		*/ \
    "Freeing up allocated memory.\n"
#define VECT_FREE__LOG		/*  vector name		*/ \
    " ... freeing up [%s]\n"
#define RFLF_CLOSE_LOG		/*  no parms		*/ \
    "Closing reflector file.\n"
#define RFL__EXIT__MSG		/*  program, version	*/ \
    "%s %s: done.\n\n"

#endif
