#ifndef MARS_MRanForestGrow
#define MARS_MRanForestGrow

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MRanForestGrow                                                          //
//                                                                         //
// Task to grow (train) a random forest                                    //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MHMatrix;
class MParList;
class MRanForest;
class MRanTree;

class MRanForestGrow : public MTask
{
private:
    MRanTree   *fRanTree;
    MRanForest *fRanForest;
    MHMatrix   *fMGammas;   //! Gammas describing matrix
    MHMatrix   *fMHadrons;  //! Hadrons (non gammas) describing matrix

    Int_t fNumTrees;
    Int_t fNumTry;
    Int_t fNdSize;

public:
    MRanForestGrow(const char *name=NULL, const char *title=NULL);

    void SetNumTrees(Int_t n);
    void SetNumTry(Int_t n);
    void SetNdSize(Int_t n);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MRanForestGrow, 0) // Task to grow a random forest
};

#endif

