#ifndef MARS_MSelFinal
#define MARS_MSelFinal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelFinal                                                               //
//                                                                         //
// Task to evaluate final cuts                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MHadronness;

class MSelFinal : public MTask
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       
    MHadronness *fHadronness;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fErrors[3];
    TString      fHilName;
    TString      fHilSrcName;
 
    Float_t      fHadronnessCut;
    Float_t      fAlphaCut;

public:
    MSelFinal(const char *HilName="MHillas", const char *HilSrcName="MHillasSrc",
              const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SetHadronnessCut(Float_t hadcut) { fHadronnessCut = hadcut; }
    void SetAlphaCut(Float_t alpha)       { fAlphaCut      = alpha;  }

    ClassDef(MSelFinal, 0)   // Task to evaluate final cuts
};

#endif











