#include "Rings.h"

#include <iostream.h>

#include "Led.h"
#include "Leds.h"

ClassImp(Rings);

void Rings::CalcCenters(const Leds &leds)
{
    Clear();

    int nPoints = leds.GetEntries();

    int n=0;
    for (int i=0; i<nPoints-2; i++)
        for (int j=i+1; j<nPoints-1; j++)
            for (int k=j+1; k<nPoints; k++)
            {
                Ring &ring = *new ((*this)[n]) Ring;

                if (!ring.CalcCenter(leds, i, j, k))
                {
                    RemoveAt(n);
                    continue;
                }

                n++;
            }

    //    Expand(n);
}

void Rings::CalcRings(Leds &leds)
{
    CalcCenters(leds);

    fCenter.InterpolCenters(*this);

    //
    // angles v
    //
    const int n=leds.GetEntries();

    for (int j=0; j<n; j++)
        leds(j).CalcPhi(fCenter);
}

void Rings::Print(Option_t *o=NULL) const
{
    cout << "Number of Rings: " << GetEntries() << endl;
    TClonesArray::Print();
    cout << "Center: " << endl;
    fCenter.Print();
}
