/*-----------------------------------------------------------------------------
dbts.h -- DBT Slave

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 94/10/11 by Soenke Hansen
Version 1.8 of 98/07/31

Definitions of DBT Protocol command specifiers.
Status definitions for service confirmations.
Prototypes of functions defined in dbts.c.

-----------------------------------------------------------------------------*/


#ifndef dbts_DEFINED
#define dbts_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h"
#include "msg.h"
#include "calconf.h"
#include "cms.h"

/* Components of service confirmation message */
#define dbts_stat	u.m1.w[0]
#define dbts_cobid	u.m1.w[1]
#define dbts_cksum	u.m1.w[2]

/* Command specifiers in DBT Protocol */
#define DBT_CS_CREATE_1		  2	/* Create User Definition part 1 */
#define DBT_CS_CREATE_2		  3	/* Create User Definition part 2 */
#define DBT_CS_CREATE_3		  4	/* Create User Definition part 3 */
#define DBT_CS_DELETE		  0	/* Delete User Definition */
#define DBT_CS_VERIFY		  5	/* Verify COB Class */
#define DBT_CS_CHECKSUM		  6	/* Get Checksum */
#define DBT_CS_NIL		255	/* Nil */


/* Status (return) values of DBT Slave services on success or failure */
#define STAT_OKAY		0x00	/* service completed successfully */
#define STAT_NOSERV		0x01	/* DBT services not allowed */
#define STAT_PROT_ERR		0x02	/* protocol error */
#define STAT_TIMED_OUT		0x03	/* timed out on confirmation */
#define STAT_TIMER_ERR		0x04	/* timer could not be set */
#define STAT_ASSIGN_ERR		0x05	/* failed to assign CAL protocol Id */
#define STAT_TX_ERR		0x10	/* service failed */
#define STAT_REMOTE_ERR		0x20	/* error code from DBT Master */

#ifdef FIRMWARE

/* DBT Slave not implemented if the distribution capability
   is not configured. */
#if CAPS_DBT & CAP_DBT_DISTRIB

/* Initialize the DBT Slave */
extern void InitDbtS(
	WORD_t	,	/* timeout interval */
	void	(*)()	/* user handler indication/confirmation */
);

/* Remove the DBT Slave */
extern void DeleteDbtS(void);

/* Request of Create User Definition Service */
extern int CreateUserDefReq(struct cob *);
extern int CreateAllUserDefReq(void);

/* Request of Delete User Definition Service */
extern int DeleteUserDefReq(int);

/* CANopen stuff */
/* Request of SYNC cob-ID */
extern WORD_t GetSYNCId(void);
extern void   PutSYNCId(WORD_t);

/* Request of SYNC pointer to CMS object */
extern struct cmso *GetPToSYNCCMS(void);
extern void   PutPToSYNCCMS(struct cmso *);

/* Request of HiRes TIMESTAMP pointer to CMS object */
extern WORD_t GetTSId(void);
extern void   PutTSId(WORD_t);

/* Request of HiRes TIMESTAMP pointer to CMS object */
extern struct cmso *GetPToTSCMS(void);
extern void   PutPToTSCMS(struct cmso *);

/* Request of time of day TIMESTAMP pointer to CMS object */
extern WORD_t GetTodTSId(void);
extern void   PutTodTSId(WORD_t);

/* Request of time of day TIMESTAMP pointer to CMS object */
extern struct cmso *GetPToTodTSCMS(void);
extern void   PutPToTodTSCMS(struct cmso *);

#if CAPS_DBT & CAP_DBT_CONSIST

/* Request of Verify COB Class Service */
extern int VerifyCobClassReq(void);

/* Request of Get Checksum Service */
extern int GetChecksumReq(int);

#endif /* CAPS_DBT & CAP_DBT_CONSIST */
#endif /* CAPS_DBT & CAP_DBT_DISTRIB */

#endif /* FIRMWARE */

#ifdef __cplusplus
}
#endif

#endif /* !dbts_DEFINED */
