/*-----------------------------------------------------------------------------
lmts.h -- LMT Slave

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 95/02/02 by Soenke Hansen
Version 1.5 of 96/04/18

Various definitions: LMT Address type, LMT command specifiers,
macros for data indicated to the LMT User.
Prototypes of functions defined in lmts.c.


-----------------------------------------------------------------------------*/


#ifndef lmts_DEFINED
#define lmts_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

#include "defs.h"
#include "msg.h"

/* There is one CAL Object associated with the LMT Slave */
extern struct calo *LmtSlave;	/* receives COBs from LMT Master */

/* LMT Address type */
struct lmt_addr {
	BYTE_t	manuf[8];	/* manufacturer name */
	BYTE_t	prod[8];	/* product name */
	BYTE_t	serno[8];	/* serial number */
};
#if TYPEDEFS == 1
typedef struct lmt_addr LmtAddr;
#else
#define LmtAddr struct lmt_addr
#endif

/* Parameters to user indications */
#define lmts_mode	u.m1.w[0]	/* LMT Mode */
#define lmts_btr	u.m1.w[0]	/* Bit Timing Parameter */

/* Command specifiers in LMT Protocol */
#define LMT_CS_SWITCH_SEL_MANUF	  1	/* Switch Mode Select: Manuf. Name */
#define LMT_CS_SWITCH_SEL_PROD    2	/* Switch Mode Select: Product Name */
#define LMT_CS_SWITCH_SEL_SERNO	  3	/* Switch Mode Select: Serial # */
#define LMT_CS_SWITCH_GLOBAL	  4	/* Switch Mode Global */
#define LMT_CS_CONF_MODID   	 17	/* Configure Module ID */
#define LMT_CS_CONF_MODNAME 	 18	/* Configure Module Name */
#define LMT_CS_CONF_BITTIME 	 19	/* Configure Bit Timing */
#define LMT_CS_ACTV_BITTIME 	 21	/* Activate Bit Timing */
#define LMT_CS_STORE_CONFIG 	 23	/* Store Configuration */
#define LMT_CS_INQUIRE_MANUF	 36	/* Inquire Manufacturer Name */
#define LMT_CS_INQUIRE_PROD 	 37	/* Inquire Product Name */
#define LMT_CS_INQUIRE_SERNO	 38	/* Inquire Serial Number */

/* Nil command specifier */
#define LMT_CS_NIL		  0	/* not used by protocols */

/* Allocate and initialize LMT Slave */
extern void InitLmtS(
	WORD_t	,	/* configured bit timing parameters */
	void	(*)()	/* user handler indication/confirmation */
);

/* Deallocate LMT Slave */
extern void DeleteLmtS(void);

/* Create LMT Address */
extern void CreateLmtAddress(LmtAddr *);

#ifdef __cplusplus
}
#endif

#endif /* !lmts_DEFINED */
