#ifndef FILTER_H
#define FILTER_H

#ifndef __CINT__
#include <TROOT.h>
#endif

typedef unsigned char byte;

class Filter
{
    static void  DrawBox(const int x1, const int y1,
                         const int x2, const int y2,
                         byte *buffer, const int col);

    static void  MarkPoint(const int x, const int y,
                           byte *buffer, const int col);

    static float Mean(const byte *buffer, const int offset,
                      int *min, int *max);

    static float SDev(const byte *buffer, const int offset,
                      const double mean);

    static int   GetMeanPosition(const byte *bitmap,
                                 const int x, const int y,
                                 const int box);

public:
    static void Execute(byte *img);

    ClassDef(Filter, 0)
};

#endif
