#ifndef MARS_MCT1SupercutsCalc
#define MARS_MCT1SupercutsCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1SupercutsCalc                                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MCerPhotEvt;
class MGeomCam;
class MHadronness;


class MCT1SupercutsCalc : public MTask
{
private:
    MHillas     *fHil;
    MHillasSrc  *fHilSrc;
    MMcEvt      *fMcEvt;
    MGeomCam    *fCam;   
    MHadronness *fHadronness;     //! output container for hadronness

    TString     fHadronnessName;  // name of container to store hadronness
    TString     fHilName;
    TString     fHilSrcName;

    Double_t    fMm2Deg;

    //---------------------------------
    // cut parameters
    Double_t fLengthUp[8];
    Double_t fWidthUp[8];
    Double_t fDistUp[8];
    Double_t fLengthLo[8];
    Double_t fWidthLo[8];
    Double_t fDistLo[8];
    Double_t fAsymUp[8];
    Double_t fAsymLo[8];
    Double_t fAlphaUp[8];
    //---------------------------------

    void InitParams();

public:
    MCT1SupercutsCalc(const char *hilname="MHillas", 
                       const char *hilsrcname="MHillasSrc",
                       const char *name=NULL, const char *title=NULL);
    ~MCT1SupercutsCalc();

    Double_t CtsMCut(Double_t *a, Double_t ls, Double_t ct, 
                     Double_t ls2, Double_t dd2);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCT1SupercutsCalc, 1) // A class to evaluate the Supercuts
};

#endif





