///////////////////////////////////////////////////////////////////////
//
// MHistosAdc
//
// This class contains a list of all ADC spektra histograms
//
///////////////////////////////////////////////////////////////////////

#include "MHistosAdc.h"

#include <iostream.h>

#include <TH1.h>
#include <TFile.h>

ClassImp(MHistosAdc)

MHistosAdc::MHistosAdc ()
{
    //
    //  default constructor
    //  creates an a list of histograms for all pixels and both gain channels
    //

    fHistHigh = new TObjArray(577);
    fHistLow  = new TObjArray(577);

    //
    //   set the name and title of this object
    //

    fName  = "MHistosAdc" ;
    fTitle = "Container for ADC spectra histograms" ;

    //
    //   loop over all Pixels and create two histograms
    //   one for the Low and one for the High gain
    //   connect all the histogram with the container fHist
    //

    Char_t  tmp1[40];
    Char_t  tmp2[40];
    TH1F    *h1;

    for ( Int_t i = 0 ; i < 577 ; i++)
    {
        sprintf ( tmp1, "high%d", i ) ;
        sprintf ( tmp2, "high gain Pixel %d", i ) ;

        h1 = new TH1F ( tmp1, tmp2, 256, 0., 255. ) ;

        fHistHigh->Add( h1 ) ;

        sprintf ( tmp1, "low %d", i ) ;
        sprintf ( tmp2, "low gain Pixel %d", i ) ;

        h1 = new TH1F ( tmp1, tmp2, 256, 0., 255. ) ;

        fHistLow->Add( h1 ) ;

    }
}

MHistosAdc::~MHistosAdc ()
{
  
  //   default destructor 
  //
  delete fHistHigh ; 
  delete fHistLow  ; 
}

void MHistosAdc::Print(Option_t *)
{
  for ( Int_t i = 0 ; i < 576 ; i++)
    {
      fHistHigh[i].Print() ;
    }
}

void MHistosAdc::FillAdcHist ( Int_t iPix, UChar_t* data)
{
  //  cout << " MHistosAdc::FillAdcHist " << endl ; 

  //
  //   fill all slices (contained in data) in the Histogram
  //   of iPix. If iPix > 10000 this is a low gain channel
  
  //
  //   check which container list is needed
  //   for high or for low gain
  //
  if ( iPix < 10000 )
    {
      //
      //   loop over data
      //
      for (Int_t i=0; i< 15; i++ )
	{
	  ((TH1F*) (fHistHigh->At(iPix)))->Fill( (Float_t) data[i]) ;
	}
    }
  else
    {
      //
      //   loop over data
      //
      for (Int_t i=0; i< 15; i++ )
        {
	  ((TH1F*) (fHistLow->At(iPix)))->Fill( (Float_t) data[i]) ;
        }
    }
}

void MHistosAdc::SaveHist ( char *name )
{
    //
    //   save all histogram in this class to a root file
    //

    TFile out( name, "recreate") ;

    //
    //  loop over all pixels and write the files out
    //

    fHistLow->Write() ;
    fHistHigh->Write() ;
}

