#ifndef MARS_MHTimeDiffTheta
#define MARS_MHTimeDiffTheta

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;
class MMcEvt;

class MParList;

class MHTimeDiffTheta : public MH
{
private:
    MTime  *fTime;   //!
    MMcEvt *fMcEvt;  //!
    Double_t fLastTime;

    TH2D    fHist;

public:
    MHTimeDiffTheta(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, Double_t w=1);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");

    ClassDef(MHTimeDiffTheta, 0) //2D-histogram  time-diff vs. Theta
};

#endif

