#ifndef MARS_MImgCleanStd
#define MARS_MImgCleanStd

#ifndef MARS_MGTask
#include "MGTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;

class MGGroupFrame;

class MImgCleanStd : public MGTask
{
private:
    const MGeomCam    *fCam;  //!
          MCerPhotEvt *fEvt;  //!

    Float_t fCleanLvl1;
    Float_t fCleanLvl2;

    void SetLvl1(Float_t lvl);
    void SetLvl2(Float_t lvl);

    void CreateGuiElements(MGGroupFrame *f);
    void StreamPrimitive(ofstream &out) const;

public:
    MImgCleanStd(const Float_t lvl1=3.0, const Float_t lvl2=2.5,
                 const char *name=NULL, const char *title=NULL);

    Int_t CleanStep1();
    void  CleanStep2(Int_t max);
    void  CleanStep3();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void Print(Option_t *o="") const;

    Float_t GetCleanLvl1() const { return fCleanLvl1; }
    Float_t GetCleanLvl2() const { return fCleanLvl2; }

    Bool_t ProcessMessage(Int_t msg, Int_t submsg, Long_t param1, Long_t param2);
    Bool_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);

    ClassDef(MImgCleanStd, 0)    // task doing a standard image cleaning
}; 

#endif

