#include <TROOT.h>
#include <TApplication.h>

#include "MAGIC.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MMars.h"
#include "MArray.h"
#include "MParContainer.h"

//#define HAVE_LOGO 1
#ifdef HAVE_LOGO
#include "MLogo.h"
#endif

// **********************************************************************
//
//    MARS main program  
//
//    The only job of the main program is the initialisation of ROOT and 
//    the start of the guiinterface for the mars program
//
//    started by  h. kornmayer      january, 3rd  2001 

void Usage()
{
    gLog << "Sorry the usage is:" << endl;
    gLog << "   mars [-vn]" << endl << endl;
    gLog << "     -v0: verbosity level: as less as possible" << endl;
    gLog << "     -v1: errors only"                          << endl;
    gLog << "     -v2: errors and warnings <default>"        << endl;
    gLog << "     -v3: errors, warnings and infos"           << endl;
}

int main(int argc, char **argv)
{
#ifdef HAVE_LOGO
    MLogo logo;
    logo.Popup();
#endif

    gLog << all << endl;

    //                1         2         3         4         5
    //       12345678901234567890123456789012345678901234567890
    gLog << "==================================================" << endl;
    gLog << "                    MARS V" << MARSVER << "                      " << endl;
    gLog << "    Magic Analysis and Reconstruction Software    " << endl;
    gLog << "            Compiled on <" << __DATE__ << ">"       << endl;
    gLog << "               Using ROOT v" << ROOTVER             << endl;
    gLog << "==================================================" << endl;
    gLog << endl;

    //
    // check for the right usage of the program
    //
    if (argc<1 || argc>2)
    {
        Usage();
        return -1;
    }

    if (argc==2)
    {
        if (argv[1][0]!='-' || argv[1][1]!='v')
        {
            Usage();
            return -1;
        }

        switch (argv[1][2])
        {
        case '0':
            gLog.SetDebugLevel(0);
            break;
        case '1':
            gLog.SetDebugLevel(1);
            break;
        case '2':
            gLog.SetDebugLevel(2);
            break;
        case '3':
            gLog.SetDebugLevel(3);
            break;
        default:
            Usage();
            return -1;
        }
    }
    else
        gLog.SetDebugLevel(2);

    //
    // Swtich of TObjectStreamer in our base classes derived from TObject
    //
    MArray::Class()->IgnoreTObjectStreamer();
    MParContainer::Class()->IgnoreTObjectStreamer();

    //
    // initialise ROOT
    //
    TROOT simple("mars", "MARS - Magic Analysis and Reconstruction Software");

    TApplication app("MarsApp", &argc, argv);

#ifdef HAVE_LOGO
    logo.Popdown();
#endif

    //
    // start the main window
    //
    new MMars;

    //
    // run the application
    //
    app.Run();

    gLog << all << endl;

    return 0;
}
 

