#ifndef MARS_MHTimeDiffTime
#define MARS_MHTimeDiffTime

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MTime;

class MParList;

class MHTimeDiffTime : public MH
{
private:
    MTime *fTime;   //!
    Double_t  fLastTime;

    TH2D   fHist;

public:
    MHTimeDiffTime(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par, Double_t w=1);

    const TH2D *GetHist() { return &fHist; }
    const TH2D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");

    ClassDef(MHTimeDiffTime, 0) //2D-histogram  time-diff vs. time
};

#endif

