#ifndef MARS_MHillasSrc
#define MARS_MHillasSrc

#ifndef MARS_MHillas
#include "MHillas.h"
#endif

class MSrcPosCam;

class MHillasSrc : public MParContainer
{
private:
    const MSrcPosCam *fSrcPos; //! Source position in the camere

    Float_t fAlpha;         // [deg]  angle of major axis with vector to src
    Float_t fDist;          // [mm]   distance between src and center of ellipse
    Float_t fCosDeltaAlpha; // [1]    cosine of angle between d and a

public:
    MHillasSrc(const char *name=NULL, const char *title=NULL);

    void SetSrcPos(const MSrcPosCam *pos) { fSrcPos = pos; }
    const MSrcPosCam *GetSrcPos() const   { return fSrcPos; }

    void Reset();

    Float_t GetAlpha()         const { return fAlpha; }
    Float_t GetDist()          const { return fDist; }
    Float_t GetCosDeltaAlpha() const { return fCosDeltaAlpha; }

    void Print(Option_t *opt=NULL) const;

    virtual Bool_t Calc(const MHillas *hillas);

    void Set(const TArrayF &arr);

    ClassDef(MHillasSrc, 4) // Container to hold source position dependant parameters
};

#endif
