/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  1/2002 <mailto:tbretz@uni-sw.gwdg.de>
!   Author(s): Wolfgang Wittek 1/2002 <mailto:wittek@mppmu.mpg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MEnergyEstimate                                                         //
//                                                                         //
// Task to estimate the energy                                             //
//                                                                         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MEnergyEstimate.h"

#include "MParList.h"

#include "MMcEvt.hxx"
#include "MHillas.h"
#include "MEnergyEst.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MEnergyEstimate);

using namespace std;


// --------------------------------------------------------------------------
//
// Default constructor.
//
MEnergyEstimate::MEnergyEstimate(const char *name, const char *title)
{
    fName  = name  ? name  : "MEnergyEstimate";
    fTitle = title ? title : "Task to estimate the energy";

    AddToBranchList("MMcEvt.fEnergy");
}

Bool_t MEnergyEstimate::PreProcess(MParList *plist)
{
   fHillas = (MHillas*)plist->FindObject("MHillas");
   if (!fHillas)
   {
       *fLog << err << dbginf << "MHillas not found... aborting." << endl;
       return kFALSE;
   }

   fMcEvt = (MMcEvt*)plist->FindObject("MMcEvt");
   if (!fMcEvt)
   {
       *fLog << err << dbginf << "MMcEvt not found... aborting." << endl;
       return kFALSE;
   }

   fEnergy = (MEnergyEst*)plist->FindCreateObj("MEnergyEst");
   if (!fEnergy)
      return kFALSE;

   return kTRUE;    
}

Bool_t MEnergyEstimate::Process()
{
  //fEnergy->SetEnergy(fHillas->GetSize());
  fEnergy->SetEnergy(fMcEvt->GetEnergy());
  return kTRUE;
}
