#include "Led.h"

#include <iostream.h>
#include <TMath.h>

#include "Ring.h"

ClassImp(Led);

void Led::CalcPhi(const Ring &ring)
{
    fPhi = TMath::ATan2(fY-ring.GetY(), fX-ring.GetX())*180/TMath::Pi();
}

void Led::Print(Option_t *o=NULL) const
{
    cout << "Led: ";
    cout << "x="   << fX   << "+-" << fDx   << ", ";
    cout << "y="   << fY   << "+-" << fDy   << ", ";
    cout << "phi=" << fPhi << "+-" << fDphi << ", ";
    cout << "mag=" << fMag << endl;
}
