#ifndef COSY_Led
#define COSY_Led

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class Ring;

class Led : public TObject
{
private:
    Double_t fX;
    Double_t fY;
    Double_t fPhi;

    Double_t fDx;
    Double_t fDy;
    Double_t fDphi;

    Double_t fMag;

public:
    Led(Double_t x=0, Double_t y=0, Double_t dx=0, Double_t dy=0, Double_t mag=0) :
        fX(x), fY(y), fDx(dx), fDy(dy), fMag(mag)
    {
    }

    Int_t Compare(const TObject *obj) const
    {
        const Led *const l = (Led*)obj;

        if (fPhi<l->fPhi)
            return -1;

        if (fPhi>l->fPhi)
            return 1;

        return 0;
    }

    Double_t GetX() const    { return fX; }
    Double_t GetY() const    { return fY; }
    Double_t GetDx() const   { return fDx; }
    Double_t GetDy() const   { return fDy; }
    Double_t GetPhi() const  { return fPhi; }
    Double_t GetDphi() const { return fDphi; }
    Double_t GetMag() const  { return fMag; }

        Bool_t IsSortable() const { return kTRUE; }

    void CalcPhi(const Ring &ring);

    void Print(Option_t *o=NULL) const;

    ClassDef(Led, 1)
};

#endif
