#ifndef MGIMAGE_H
#define MGIMAGE_H

//
// This File contains the declaration of the MGImage-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#include <TGFrame.h>

class TTimer;

typedef unsigned char byte;

class MGImage : public TGFrame
{
    char fColors[0x100][3];

    char **fBuffer;
    char **fBody;

    GContext_t fDefGC;
    Pixmap_t   fPixmap;

    UInt_t fWidth;
    UInt_t fHeight;

    void *fMuxPixmap; //! test

    TTimer *fTimer;

    enum { kNeedRecreate = BIT(17) };

public:
    MGImage(const TGWindow* p, UInt_t w, UInt_t h, UInt_t options = kSunkenFrame, ULong_t back = fgDefaultFrameBackground);
    ~MGImage();

    void DoRedraw();

    void Resize(UInt_t w, UInt_t h);
    void Resize(TGDimension size);
    void MoveResize(Int_t x, Int_t y, UInt_t w, UInt_t h);

    void DrawImg(const byte *buffer);
    void DrawColImg(const byte *gbuf, const byte *cbuf);

    ClassDef(MGImage, 0)
};

#endif // MGIMAGE_H
