#include <TROOT.h>
#include <TApplication.h>

#include <iostream.h>

#include "Camera.h"
#include "PngReader.h"
#include "MGStarguider.h"

/* ---------------------------------------------------------------------- */
//extern void InitGui();
//VoidFuncPtr_t initfuncs[] = { InitGui, 0 };

TROOT root("GUI", "GUI test environement"); //, initfuncs);

int main(int argc, char **argv)
{
    TApplication *app=new TApplication("Starguider", &argc, argv);

    Bool_t dummy = kFALSE;

    for (int i=0; i<argc; i++)
    {
        TString arg(argv[i]);
        if (arg=="-d")
            dummy = kTRUE;
    }

    PixClient *client=new MGStarguider(MObservatory::kMagic1);

    if (dummy)
    {
        cout << " --> Starting in dummy-mode. <--" << endl;
        PngReader *read=new PngReader(*client);
        app->Run(kTRUE);
        read->ExitLoop();
        delete read;
        //        delete client;
    }
    else
    {
        cout << " --> Starting in real-mode. <--" << endl;
        //PixClient *client=new MGStarguider(MObservatory::kMagic1);
        Camera *cam = new Camera(*client);
        cam->Loop(0);
        app->Run(kTRUE);
        cam->ExitLoop();
        delete cam;
        //        delete client;
    }

    delete client;


    cout << "Application end...." << endl;

    cout << "Exit." << endl;

    return 0;
}
