/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Abelardo Moralejo <mailto:moralejo@pd.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// pixfirerate.C
//
// This macro can help to  find "hot" pixels firing too often
// or pixels firing too rarely. It plots camera displays showing how many 
// times the FADC integral of each pixel has been found to be above pedestal
// by 10, 20, 50, 100 or 200 ADC counts. As "pedestal"  we now use simply 
// the signal in the first ADC slice, which seemed reasonable from a first
// look at the available test data.
//
/////////////////////////////////////////////////////////////////////////////

void pixfirerate(TString filename="20030603_01731_D_cosmics_E.root")
{
    //
    // Update frequency by default = 1Hz
    //
    MStatusDisplay *d = new MStatusDisplay;

    // Set update time to 5s
    // d->SetUpdateTime(5000);

    // Disable online update
    // d->SetUpdateTime(-1);

    d->SetLogStream(&gLog, kTRUE); // Disables output to stdout
    gLog.SetOutputFile("status.log", kTRUE); // Enable output to file
    //gLog.EnableOutputDevice(MLog::eStdout); // Enable output to stdout again

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;
    MTaskList tlist;
    plist.AddToList(&tlist);

    // The geometry container must be created by yourself to make sure
    // that you don't choose a wrong geometry by mistake
    //
    MGeomCamMagic geomcam;
    plist.AddToList(&geomcam);

    //
    // Now setup the tasks and tasklist:
    // ---------------------------------
    //
    MReadMarsFile read("Events");
    read.DisableAutoScheme();

    MHTrigLvl0 trigmap1(10.,"Above 10");
    MHTrigLvl0 trigmap2(20.,"Above 20");
    MHTrigLvl0 trigmap3(50.,"Above 50");
    MHTrigLvl0 trigmap4(100.,"Above 100");
    MHTrigLvl0 trigmap5(200.,"Above 200");

    plist.AddToList(&trigmap1);
    plist.AddToList(&trigmap2);
    plist.AddToList(&trigmap3);
    plist.AddToList(&trigmap4);
    plist.AddToList(&trigmap5);

    MFillH fill1("Above 10","MRawEvtData");
    MFillH fill2("Above 20","MRawEvtData");
    MFillH fill3("Above 50","MRawEvtData");
    MFillH fill4("Above 100","MRawEvtData");
    MFillH fill5("Above 200","MRawEvtData");

    read.AddFile(filename);

    tlist.AddToList(&read);
    tlist.AddToList(&fill1);
    tlist.AddToList(&fill2);
    tlist.AddToList(&fill3);
    tlist.AddToList(&fill4);
    tlist.AddToList(&fill5);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);
    evtloop.SetDisplay(d);

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    tlist.PrintStatistics();

    //
    // Make sure the display hasn't been deleted by the user while the
    // eventloop was running.
    //
    if ((d = evtloop.GetDisplay()))
    {
        // Save data in a postscriptfile (status.ps)
        d->SaveAsPS();
        /*
         * ----------- Write status to a root file ------------
         *
         TFile file("status.root", "RECREATE");
         d->Write();
         file.Close();
         delete d;
         */
    }

}
