/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz 03/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MParameterD, MParameterI
//
// Storage Container for doubles and ints
//
// This classes can be used for intermidiate variables which we don't want
// to have in a special container.
//
/////////////////////////////////////////////////////////////////////////////
#include "MParameters.h"

#include <fstream>

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MParameterD);
ClassImp(MParameterI);
//ClassImp(MParameter);

using namespace std;

// --------------------------------------------------------------------------
//
// Default constructor.
//
MParameterD::MParameterD(const char *name, const char *title)
{
    fName  = name  ? name  : "MParameterD";
    fTitle = title ? title : "Storgare container for general parameters (double)";
}

// --------------------------------------------------------------------------
//
// Default constructor.
//
MParameterI::MParameterI(const char *name, const char *title)
{
    fName  = name  ? name  : "MParameterI";
    fTitle = title ? title : "Storgare container for general parameters (integer)";
}

