#ifndef MARS_MDirIter
#define MARS_MDirIter

#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif

class MDirIter : public TObject
{
private:
    TObjArray fList;
    TString   fFilter;

    TIter     fNext;        //!
    void     *fDirPtr;      //!
    TObject  *fCurrentPath; //!

    void   *Open();
    void    Close();
    Bool_t  Check(const TString n) const;
    Int_t   IsDir(const char *dir) const;
    Bool_t  MatchFilter(const TString &name, const TString &filter) const;
    TString ConcatFileName(const char *dir, const char *name) const;
    void    PrintEntry(const TObject &o) const;

public:
    MDirIter() : fNext(&fList), fDirPtr(NULL)
    {
        fList.SetOwner();
    }
    MDirIter(const MDirIter &dir) : fNext(&fList), fDirPtr(NULL)
    {
        fList.SetOwner();

        TObject *o=NULL;
        TIter Next(&dir.fList);
        while ((o=Next()))
            AddDirectory(o->GetName(), o->GetTitle());
    }
    MDirIter(const char *dir, const char *filter="") : fNext(&fList), fDirPtr(NULL)
    {
        fList.SetOwner();
        AddDirectory(dir, filter);
    }
    ~MDirIter()
    {
        Close();
    }

    Int_t AddDirectory(const char *dir, const char *filter="", Int_t recursive=0);
    void  Reset()
    {
        Close();
        fNext.Reset();
    }

    TString Next(Bool_t nocheck=kFALSE);
    TString operator()(Bool_t nocheck=kFALSE) { return Next(nocheck); }

    void SetFilter(const char *f="") { fFilter = f; }

    void Print(const Option_t *o="") const;

    ClassDef(MDirIter, 1) // Iterator for files in several directories (with filters)
};

#endif
