#ifndef MARS_MHCerPhotEvt
#define MARS_MHCerPhotEvt

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef MARS_MCerPhotEvt
#include "MCerPhotEvt.h"
#endif

class TH1D;
class MCamDisplay;

class MHCerPhotEvt : public MH
{
private:
    MCerPhotEvt  fSum;      // storing the sum
    Int_t        fEntries;  // number of entries in the histogram
    MGeomCam    *fCam;      // the present geometry
    MCerPhotEvt *fEvt;      //! the current event
    MCamDisplay *fDispl;    //! the camera display

public:
    MHCerPhotEvt(const char *name=NULL, const char *title=NULL);
    ~MHCerPhotEvt();

    void Clear(const Option_t *o="");

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, const Stat_t w=1);
    Bool_t Finalize();

    TH1 *GetHistByName(const TString name) { return NULL; }

    const MCerPhotEvt &GetSum() const { return fSum; }

    void Draw(Option_t *opt="");
    void Paint(Option_t *option="");

    ClassDef(MHCerPhotEvt, 1) // Histogram to sum camera events
};

#endif
