#ifndef MARS_MArgs
#define MARS_MArgs

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_TNamed
#include <TNamed.h>
#endif

#ifndef ROOT_TList
#include <TList.h>
#endif

class MArgsEntry : public TString, public TObject
{
public:
    MArgsEntry(const char *c) : TString(c), TObject() {}

    void Print(const Option_t *o) const;

    ClassDef(MArgsEntry, 0)
};

class MArgs : public TNamed
{
private:
    Int_t fArgc;
    TList fArgv;

public:
    MArgs(int argc, const char **argv);

    void Print(const Option_t *o="") const;

    // FIXME: Add max, min option
    // FIXME: Add default option

    Int_t    GetInt(const TString name) const;
    Double_t GetFloat(const TString name) const;
    TString  GetString(const TString name) const;

    Int_t    GetIntAndRemove(const TString name);
    Double_t GetFloatAndRemove(const TString name);
    TString  GetStringAndRemove(const TString name);

    Bool_t Has(const TString name) const;
    Bool_t HasOption(const TString name) const;

    TString GetArgumentStr(Int_t i) const;
    Int_t   GetArgumentInt(Int_t i) const;
    Float_t GetArgumentFloat(Int_t i) const;
    Int_t   GetNumArguments() const;

    ClassDef(MArgs, 0)  //Class to parse command line arguments
};

#endif
