#ifndef MARS_MBlindPixelCalc
#define MARS_MBlindPixelCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayS
#include <TArrayS.h>
#endif

class MGeomCam;
class MCerPhotEvt;
class MBlindPixels;

class MBlindPixelCalc : public MTask
{
private:
    MCerPhotEvt  *fEvt;     //!
    MBlindPixels *fPixels;  //!
    MGeomCam     *fGeomCam; //!

    TArrayS fPixelsIdx;  // Pixel Indices for blind pixels, which are entered by the user.

    Byte_t fFlags;      // flag for the method which is used

    enum
    {
        kUseInterpolation = 1,
        kUseCentralPixel  = 2,
        kUseBlindPixels   = 3
    };

    void Interpolate() const;
    void Unmap() const;
    void StreamPrimitive(ofstream &out) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MBlindPixelCalc(const char *name=NULL, const char *title=NULL);

    void SetUseInterpolation(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseInterpolation) : CLRBIT(fFlags, kUseInterpolation);
    }
    void SetUseCentralPixel(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseCentralPixel) : CLRBIT(fFlags, kUseCentralPixel);
    }
    void SetUseBlindPixels(Bool_t b=kTRUE)
    {
        b ? SETBIT(fFlags, kUseBlindPixels) : CLRBIT(fFlags, kUseBlindPixels);
    }

    void SetPixelIndices(const TArrayS &pix) { fPixelsIdx = pix; }
    virtual Bool_t ReInit(MParList *pList);

    ClassDef(MBlindPixelCalc, 1) // task to deal with hot spots (star, broken pixels, etc)
}; 

#endif

