/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  9/2002 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// MMatrixLoop
//
// Use this task instead of reading from a file. It loops through the rows
// of a given MHMatrix. PreProcessing the task again starts from scratch.
//
/////////////////////////////////////////////////////////////////////////////
#include "MMatrixLoop.h"

#include "MHMatrix.h"

ClassImp(MMatrixLoop);

const TString MMatrixLoop::gsDefName  = "MMatrixLoop";
const TString MMatrixLoop::gsDefTitle = "Loop through a MHMatrix (instead of reading from a file)";

// --------------------------------------------------------------------------
//
//  Default Constructor. Specify the MHMatrix object you want to loop
//  through.
//
MMatrixLoop::MMatrixLoop(MHMatrix *mat, const char *name, const char *title) : fMatrix(mat)
{
    fName  = name  ? name  : gsDefName.Data();
    fTitle = title ? title : gsDefTitle.Data();
}

// --------------------------------------------------------------------------
//
// Set the present row of the Matrix, stops the loop when all rows have
// been accessed.
//
Int_t MMatrixLoop::Process()
{
    return fMatrix->SetNumRow(fNumRow++);
}

