#ifndef MARS_MCT1Supercuts
#define MARS_MCT1Supercuts


#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#ifndef ROOT_TString
#include <TString.h>
#endif

#ifndef MARS_MParContainer
#include <MParContainer.h>
#endif



class MCT1Supercuts : public MParContainer
{
private:

    UInt_t     fNpartot;

    //---------------------------------
    // supercut parameters

    TArrayD fLengthUp;
    TArrayD fLengthLo;
    TArrayD fWidthUp;
    TArrayD fWidthLo;
    TArrayD fDistUp;
    TArrayD fDistLo;
    TArrayD fAsymUp;
    TArrayD fAsymLo;
    TArrayD fAlphaUp;
    //---------------------------------


public:
    MCT1Supercuts(const char *name=NULL, const char *title=NULL);

    void InitParams();

    void SetParams(UInt_t npar, TArrayD &d);
    void GetParams(UInt_t npar, TArrayD &d);

    TArrayD &GetLengthUp()  { return fLengthUp; }
    TArrayD &GetLengthLo()  { return fLengthLo; }
    TArrayD &GetWidthUp()   { return fWidthUp; }
    TArrayD &GetWidthLo()   { return fWidthLo; }
    TArrayD &GetDistUp()    { return fDistUp; }
    TArrayD &GetDistLo()    { return fDistLo; }
    TArrayD &GetAsymUp()    { return fAsymUp; }
    TArrayD &GetAsymLo()    { return fAsymLo; }
    TArrayD &GetAlphaUp()   { return fAlphaUp; }

    ClassDef(MCT1Supercuts, 1) // A container for the Supercut parameters
};

#endif














