#ifndef MARS_MTaskInteractive
#define MARS_MTaskInteractive

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTaskInteractive                                                               //
//                                                                         //
// Does nothing than return kCONTINUE in the Process-fucntion              //
// (use with filters)                                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MFilter;
class MTaskList;

class MTaskInteractive : public MTask
{
private:
    TMethodCall *fCall[3];

    Int_t (*fPreProcess)(MParList *list);
    Int_t (*fProcess)();
    Int_t (*fPostProcess)();

    Int_t PreProcess(MParList *list) { if (fCall[0]) return Return(0, &list); return fPreProcess  ? (*fPreProcess)(list) : kTRUE; }
    Int_t Process()                  { if (fCall[1]) return Return(1);        return fProcess     ? (*fProcess)()        : kTRUE; }
    Int_t PostProcess()              { if (fCall[2]) return Return(2);        return fPostProcess ? (*fPostProcess)()    : kTRUE; }

    Int_t Return(Int_t no, void *param=NULL);
    Bool_t Set(void *fcn, Int_t no, const char *params);
    void   Free(Int_t no);

public:
    MTaskInteractive(const char *name=NULL, const char *title=NULL);
    ~MTaskInteractive();

    // This is to be used in compiled code
    void SetPreProcess(Int_t (*func)(MParList *list)) { fPreProcess = func;  Free(0); }
    void SetProcess(Int_t (*func)())                  { fProcess = func;     Free(1);  }
    void SetPostProcess(Int_t (*func)())              { fPostProcess = func; Free(2);  }

    // This is for usage in CINT
    void SetPreProcess(void *fcn)  { Set(fcn, 0, "MParList*"); fPreProcess =0; }
    void SetProcess(void *fcn)     { Set(fcn, 1, "");          fProcess    =0; }
    void SetPostProcess(void *fcn) { Set(fcn, 2, "");          fPostProcess=0; }

    ClassDef(MTaskInteractive, 0) // Interactive task
};

#endif
