//
//  --> Frist of all the WIDTH of the time slice of one FADC slice 
//      this is 3.33333 nsec.
//
#define WIDTH_FADC_TIMESLICE   (50./15.)       //  this means 3.33 nsec 
//
//  --> Second the number of slices to fill in MFADC. This must by 
//      connected to the MTrigger class. The time of interest must be
//      equal in both classes. 
//
#define SLICES_MFADC           (TOTAL_TRIGGER_TIME / WIDTH_FADC_TIMESLICE)
//
//  --> The amount of FADC slice written to the raw format.
//
#define FADC_SLICES  15
//
//  --> The amount of ns before trigger that would be read from the ADC
//      in oder to show also the start of the pulse before the
//      the trigger time.
//
#define TIME_BEFORE_TRIGGER    10.
//  --> like the trigger the FADC value will also have a standard response
//      to one single Photo electron. This response is binned with smaller
//      bins. The WIDTH of that response function is done here. 
// 
#define SUBBINS     5.
#define WIDTH_RESPONSE_MFADC   (WIDTH_FADC_TIMESLICE /  SUBBINS )  
// 5 sub-bin in one FADC slice 
//
//  --> the number of Response slices
//
#define RESPONSE_SLICES_MFADC   45         
//
//
#define MFADC_RESPONSE_FWHM        5.0

//
//
#define MFADC_RESPONSE_AMPLITUDE   4.0
//
// -->  The maximum number of FADC channels
//      Most likely it will be always equal to CAMERA_PIXELS 
#define MFADC_CHANNELS  3500
//
// Ratio of high to low gain:
//
#define HIGH2LOWGAIN 10.
