/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Wolfgang Wittek, 08/2003 <mailto:wittek@mppmu.mpg.de>
!   Author(s): Thomas Bretz, 08/2003 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2003
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MCT1Supercuts                                                         //
//                                                                         //
//   this is the container for the parameters of the supercuts             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MCT1Supercuts.h"

#include <math.h>
#include <fstream>

#include "MParList.h"

#include "MLog.h"
#include "MLogManip.h"

ClassImp(MCT1Supercuts);

using namespace std;

// --------------------------------------------------------------------------
//
// constructor
//
MCT1Supercuts::MCT1Supercuts(const char *name, const char *title)
    : fParameters(72),
    fLengthUp(fParameters.GetArray()), fLengthLo(fParameters.GetArray()+8),
    fWidthUp(fParameters.GetArray()+16), fWidthLo(fParameters.GetArray()+24),
    fDistUp(fParameters.GetArray()+32), fDistLo(fParameters.GetArray()+40),
    fAsymUp(fParameters.GetArray()+48), fAsymLo(fParameters.GetArray()+56),
    fAlphaUp(fParameters.GetArray()+64)
{
    fName  = name  ? name  : "MCT1Supercuts";
    fTitle = title ? title : "Container for the supercut parameters";

    // set supercut parameters to their default values
    InitParameters();
}


// --------------------------------------------------------------------------
//
// set default values for the supercut parameters
//
void MCT1Supercuts::InitParameters()
{
    fLengthUp[0] =  0.315585;
    fLengthUp[1] =  0.001455;
    fLengthUp[2] =  0.203198;
    fLengthUp[3] =  0.005532;
    fLengthUp[4] = -0.001670;
    fLengthUp[5] = -0.020362;
    fLengthUp[6] =  0.007388;
    fLengthUp[7] = -0.013463;

    fWidthUp[0] =  0.145412;
    fWidthUp[1] = -0.001771;
    fWidthUp[2] =  0.054462;
    fWidthUp[3] =  0.022280;
    fWidthUp[4] = -0.009893;
    fWidthUp[5] =  0.056353;
    fWidthUp[6] =  0.020711;
    fWidthUp[7] = -0.016703;

    fDistUp[0] =  1.787943;
    fDistUp[1] =  0;
    fDistUp[2] =  2.942310;
    fDistUp[3] =  0.199815;
    fDistUp[4] =  0;
    fDistUp[5] =  0.249909;
    fDistUp[6] =  0.189697;
    fDistUp[7] =  0;

    fLengthLo[0] =  0.151530;
    fLengthLo[1] =  0.028323;
    fLengthLo[2] =  0.510707;
    fLengthLo[3] =  0.053089;
    fLengthLo[4] =  0.013708;
    fLengthLo[5] =  2.357993;
    fLengthLo[6] =  0.000080;
    fLengthLo[7] = -0.007157;

    fWidthLo[0] =  0.089187;
    fWidthLo[1] = -0.006430;
    fWidthLo[2] =  0.074442;
    fWidthLo[3] =  0.003738;
    fWidthLo[4] = -0.004256;
    fWidthLo[5] = -0.014101;
    fWidthLo[6] =  0.006126;
    fWidthLo[7] = -0.002849;

    fDistLo[0] =  0.589406;
    fDistLo[1] =  0;
    fDistLo[2] = -0.083964;
    fDistLo[3] = -0.007975;
    fDistLo[4] =  0;
    fDistLo[5] =  0.045374;
    fDistLo[6] = -0.001750;
    fDistLo[7] =  0;

    fAsymUp[0] =  0.061267;
    fAsymUp[1] =  0.014462;
    fAsymUp[2] =  0.014327;
    fAsymUp[3] =  0.014540;
    fAsymUp[4] =  0.013391;
    fAsymUp[5] =  0.012319;
    fAsymUp[6] =  0.010444;
    fAsymUp[7] =  0.008328;

    fAsymLo[0] = -0.012055;
    fAsymLo[1] =  0.009157;
    fAsymLo[2] =  0.005441;
    fAsymLo[3] =  0.000399;
    fAsymLo[4] =  0.001433;
    fAsymLo[5] = -0.002050;
    fAsymLo[6] = -0.000104;
    fAsymLo[7] = -0.001188;

    fAlphaUp[0] = 13.123440; 
    fAlphaUp[1] = 0;
    fAlphaUp[2] = 0;
    fAlphaUp[3] = 0;
    fAlphaUp[4] = 0;
    fAlphaUp[5] = 0;
    fAlphaUp[6] = 0;
    fAlphaUp[7] = 0;
}


// --------------------------------------------------------------------------
//
// Set the parameter values from the array 'd'
//
//
Bool_t MCT1Supercuts::SetParameters(const TArrayD &d)
{
    if (d.GetSize() != fParameters.GetSize())
        // *fLog << err << ...
        return kFALSE;

    fParameters = d;
    return kTRUE;
}
