#ifndef MARS_MReadCurrents
#define MARS_MReadCurrents

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TList;
class MTime;
class MCurrents;

class MReadCurrents : public MTask
{
private:
    ifstream  *fIn;          // the inputfile
    MTime     *fTime;        //
    MCurrents *fCurrents;    //
    TList     *fFileNames;   // Array which stores the \0-terminated filenames

    Bool_t OpenNextFile();

public:
    MReadCurrents(const char *filename=NULL,
                  const char *name=NULL,
                  const char *title=NULL);

    ~MReadCurrents();

    Int_t AddFile(const char *fname, Int_t dummy=-1);

    Int_t PreProcess(MParList *pList);
    Int_t Process();

    ClassDef(MReadCurrents, 0)	// Reads a Central Control currents file
};

#endif

