//
//
//      In this file are the fundamental definitions for the class MCTrigger
//
//
#define TRIGGER_PIXELS        3500
//
//      This is the number of Pixels contributing to the TRIGGER logic
//      All Pixels-Id above that value don't do an trigger stuff. 
//      Actually, not all of them are involved in TRIGGER logic, only the
//      ones of them that are also in some TRIGGER_CELL 
//   (MagicSoft/Simulation/Detector/include-MTrigger/TABLE_PIXELS_IN_CELLS)
//
#define TOTAL_TRIGGER_TIME    160 
//
//      This values defines the total range in that we try to find
//      a trigger. 
//
#define LEVEL1_DEAD_TIME    50
//
//      Dead time of the detector after one first level trigger happens.
//
#define LEVEL2_DEAD_TIME    300
//
//      Dead time of the detector after second level trigger fires
//
#define SLICES_PER_NSEC         4
//      
//      Each nano second is divided into the number of this values slices. 
//      So you can get the total number of timeslices for one Pixel by 
//      ( TOTAL_TRIGGER_TIME * SLICES_PER_NSEC ). 
//      In the current settings this are 1000 slices
//
#define TRIGGER_TIME_SLICES     (TOTAL_TRIGGER_TIME*SLICES_PER_NSEC) 
//
//
//
//
//       ------>>>   SETTINGS for the RESPONSE FUNCTION
// 
#define RESPONSE_SLICES        40
//
//       This is for the standard response Signal to 1 Photoelectron
//       that leaves the Photocathode
//       The whole Timescale for the signal is 10 nsec
//
//       The Response function
//
//       These values are discussed with Eckart. We start from this point. 
//
#define RESPONSE_FWHM          2. 

#define RESPONSE_AMPLITUDE     1. 
//
//       This are the Standard values of the response function for
//       1 photo electron. ( 1 means 1 mV per phote electron ) 
//
//
//       -------->>> SETTINGS for the DISKRIMINATORS
//
//
#define CHANNEL_THRESHOLD      2.5 
//
//       This is the diskriminator threshold for each individual channel
//       First we set the value to 2 unit of the RESPONSE_AMPLITUDE 
//
#define TRIGGER_GATE           3. 
// 
//       Here we set the width of the digital signal we get if the signal
//       passes the diskriminator
//
//
#define TRIGGER_OVERLAPING           0.25 
// 
//       Here we set the required overlaping time among pixels
//       to be in coincidence.
//
//
//      --------->>>> SETTINGS for the TRIGGER logic
//
//
#define TRIGGER_CELLS          19  
//
//       Number of trigger cells that cover the trigger zone
//
#define TRIGGER_MULTI          4.  
//
//       We get a Level Zero Trigger, if we have a least TRIGGER_MULTI
//       channels with a diskrimiator signal at the same time 
//
#define TRIGGER_GEOM           0
//
//      This defines the geometry required for a trigger. There exists 
//      different meaning for this behaviour: 
//         0 means a pixel with trigger_multi-1 neighbours
//         1 means trigger_multi neighbours
//         2 means trigger_multi closed neighbours
//
