#include <iostream.h>

#include <TGFrame.h>
#include <TGLabel.h>
#include <TGButton.h>

#include "MGList.h"


class MFit : public TGMainFrame
{
private:
    enum {
        kCbIA,
        kCbIE,
        kCbNPAE,
        kCbCA,
        kCbAN,
        kCbAW,
        kCbCRX,
        kCbCRY,
        kCbNRX,
        kCbNRY
    };

    MGList *list;

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2)
    {
        cout << "Msg: " << hex << GET_MSG(msg) << endl;
        cout << "SubMsg: " << hex << GET_SUBMSG(msg) << endl;
        switch (GET_MSG(msg))
        {
        case kC_COMMAND:
            switch (GET_SUBMSG(msg))
            {
            case kCM_CHECKBUTTON:
                /*
                 TGCheckButton *but = (TGCheckButton*)list->FindWidget(mp1);
                 cout << hex << but->GetName() << " " << mp2 << endl;
                 */
                return kTRUE;
            }
            return kTRUE;
        }
        return kTRUE;
    }

    void AddTextButton(TGCompositeFrame *f, TString txt, Int_t id=-1, TGLayoutHints *h=0)
    {
        TGButton *but = new TGTextButton(f, txt, id);
        but->Associate(this);
        f->AddFrame(but, h);
        list->Add(but);

    }

    void AddCheckButton(TGCompositeFrame *f, TString txt, Int_t id=-1, TGLayoutHints *h=0)
    {
        TGButton *but = new TGCheckButton(f, txt, id);
        but->Associate(this);
        f->AddFrame(but, h);
        list->Add(but);
    }

    void AddLabel(TGCompositeFrame *f, TString txt, TGLayoutHints *h=0, TList *label=0)
    {
        TGLabel *l = new TGLabel(f, txt);
        f->AddFrame(l, h);
        list->Add(l);
        if (label)
            label->Add(l);
    }

public:
    MFit() : TGMainFrame(gClient->GetRoot(), 550, 350, kHorizontalFrame)
    {
        list = new MGList;
        list->SetOwner();

        TGLayoutHints *hints0 = new TGLayoutHints(kLHintsExpandY, 7, 5, 5, 6);
        TGLayoutHints *hints1 = new TGLayoutHints(kLHintsExpandX|kLHintsExpandY, 5, 7, 5, 6);
        TGLayoutHints *hints2 = new TGLayoutHints(kLHintsCenterX|kLHintsCenterY, 5, 5, 5, 5);
        list->Add(hints0);
        list->Add(hints1);
        list->Add(hints2);

        TGGroupFrame *grp1 = new TGGroupFrame(this, "Control", kVerticalFrame);
        AddFrame(grp1, hints0);
        list->Add(grp1);

        TGGroupFrame *grp2 = new TGGroupFrame(this, "Parameters", kHorizontalFrame);
        AddFrame(grp2, hints1);
        list->Add(grp2);



        TGLayoutHints *hints4 = new TGLayoutHints(kLHintsExpandX, 5, 5, 10);
        AddTextButton(grp1, "Load Bending Model", -1, hints4);
        AddTextButton(grp1, "Save Bending Model", -1, hints4);
        AddTextButton(grp1, "Load Observations",  -1, hints4);
        AddTextButton(grp1, "Fit Parameters",     -1, hints4);
        AddTextButton(grp1, "Reset Parameters",   -1, hints4);


        TGHorizontalFrame *comp = new TGHorizontalFrame(grp2, 1, 1);
        grp2->AddFrame(comp);
        list->Add(comp);

        TGLayoutHints *hints3 = new TGLayoutHints(kLHintsLeft|kLHintsTop, 0, 20, 5, 0);
        list->Add(hints3);

        TGLabel *l;

        TGVerticalFrame *vframe = new TGVerticalFrame(comp, 1, 1);
        comp->AddFrame(vframe, hints3);
        list->Add(vframe);

        AddCheckButton(vframe, "IA",   kCbIA);
        AddCheckButton(vframe, "IE",   kCbIE);
        AddCheckButton(vframe, "NPAE", kCbNPAE);
        AddCheckButton(vframe, "CA",   kCbCA);
        AddCheckButton(vframe, "AN",   kCbAN);
        AddCheckButton(vframe, "AW",   kCbAW);
        AddCheckButton(vframe, "CRX",  kCbCRX);
        AddCheckButton(vframe, "CRY",  kCbCRY);
        AddCheckButton(vframe, "NRX",  kCbNRX);
        AddCheckButton(vframe, "NRY",  kCbNRY);

        vframe = new TGVerticalFrame(comp, 1, 1);
        comp->AddFrame(vframe, hints3);
        list->Add(vframe);


        TList label;

        l = new TGLabel(vframe, "0");
        list->Add(l);
        label.Add(l);

        TGButton *but = (TGButton*)list->FindWidget(kCbIA);

        TGLayoutHints *h = new TGLayoutHints(kLHintsCenterY, 0, 0, but->GetHeight()-l->GetHeight());
        list->Add(h);

        vframe->AddFrame(l,h);

        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);

        vframe = new TGVerticalFrame(comp, 1, 1);
        comp->AddFrame(vframe, hints3);
        list->Add(vframe);

        AddLabel(vframe, "Offset Azimuth",         h, &label);
        AddLabel(vframe, "Offset Zenith Distance", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);
        AddLabel(vframe, "0", h, &label);

        Layout();

        MapSubwindows();
        MapWindow();




        l = (TGLabel*)label.At(0);
        l->SetText("221.4567");

        l = (TGLabel*)label.At(1);
        l->SetText("-1.65423");

        Layout();
    }
};

void gui()
{
    new MFit;
}
